//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Importer.h"
#include "3dsftk.h"
#include "math/matrix.h"

//---------------------------------------------------------------------------
bool Import3DS::PrintError(void)
{
if (ftkerr3ds)
   {
	const ErrRec3ds *pErr = ReturnErrorList3ds ();
	char sErr[1024];
   sprintf(sErr, "ERROR (%d): %s", pErr->id, pErr->desc);
   ShowMessage(sErr);
	}
return (bool) ftkerr3ds;
}


//---------------------------------------------------------------------------
bool Import3DS::BeginImport(char * filename)
{
ClearErrList3ds();

file = OpenFile3ds ((LPCTSTR) filename, "rw");
if (PrintError()) return false;

db = NULL;
InitDatabase3ds (&db);
if (PrintError()) return false;

CreateDatabase3ds (file, db);
if (PrintError()) return false;

meshlist = NULL;
GetMeshNameList3ds (db, &meshlist);
if (PrintError ()) return false;


return true;
}


//---------------------------------------------------------------------------
void Import3DS::EndImport(void)
{
ReleaseDatabase3ds (&db);
if (PrintError ()) return;

CloseAllFiles3ds ();
if (PrintError ()) return;
}


//---------------------------------------------------------------------------
int Import3DS::GetMeshCount(void)
{
return meshlist->count;
}

//---------------------------------------------------------------------------
int Import3DS::GetVertexCount(int mesh_index)
{
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return 0;
return mesh->nvertices;
}


//---------------------------------------------------------------------------
int Import3DS::GetFaceCount(int mesh_index)
{
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return 0;
return mesh->nfaces;
}

//---------------------------------------------------------------------------
void Import3DS::GetVertex(int mesh_index, int vertex_index, float * x,float * y,float * z)
{
matrix44 temp_matrix;
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return;
*x = mesh->vertexarray[vertex_index].x;
*y = mesh->vertexarray[vertex_index].y;
*z = mesh->vertexarray[vertex_index].z;


temp_matrix.set( mesh->locmatrix[0], mesh->locmatrix[3], mesh->locmatrix[6], mesh->locmatrix[9],
                 mesh->locmatrix[1], mesh->locmatrix[4], mesh->locmatrix[7], mesh->locmatrix[10],
                 mesh->locmatrix[2], mesh->locmatrix[5], mesh->locmatrix[8], mesh->locmatrix[11],
                 0,0,0,1);

temp_matrix.transpose();
temp_matrix.invert();
vector3 vt(*x, *y, *z);
vector3 v = temp_matrix.Transform(vt);

kfmesh3ds * kf_mesh = NULL;

GetObjectMotionByName3ds(db,meshlist->list[mesh_index].name, &kf_mesh);
if (PrintError ())return;

vector3 pivot(0,0,0);

if (kf_mesh) pivot.set(-kf_mesh->pivot.x,-kf_mesh->pivot.y,-kf_mesh->pivot.z);

v = v + pivot;

*x = v.x;
*y = v.y;
*z = v.z;
}

//---------------------------------------------------------------------------
void Import3DS::GetTexcoords(int mesh_index, int vertex_index, float * u,float * v)
{
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return;

if (mesh->ntextverts != mesh->nvertices) return;
*u = mesh->textarray[vertex_index].u;
*v = mesh->textarray[vertex_index].v;
}


//---------------------------------------------------------------------------
void Import3DS::GetFace(int mesh_index, int face_index, int * v1, int * v2, int * v3)
{
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return;
*v1 = mesh->facearray[face_index].v1;
*v2 = mesh->facearray[face_index].v2;
*v3 = mesh->facearray[face_index].v3;
}


//---------------------------------------------------------------------------
float Import3DS::GetMatrix(int mesh_index, int i, int j)
{
matrix44 temp_matrix;
mesh3ds *mesh = NULL;
GetMeshByName3ds (db, meshlist->list[mesh_index].name, &mesh);
if (PrintError ())return NULL;

temp_matrix.set( mesh->locmatrix[0], mesh->locmatrix[3], mesh->locmatrix[6], mesh->locmatrix[9],
                 mesh->locmatrix[1], mesh->locmatrix[4], mesh->locmatrix[7], mesh->locmatrix[10],
                 mesh->locmatrix[2], mesh->locmatrix[5], mesh->locmatrix[8], mesh->locmatrix[11],
                 0,0,0,1);


temp_matrix.transpose();

vector3 a;
a = temp_matrix.x_component();
a.norm();
temp_matrix.set_x(a);

a = temp_matrix.y_component();
a.norm();
temp_matrix.set_y(a);

a = temp_matrix.z_component();
a.norm();
temp_matrix.set_z(a);

return temp_matrix.m[i][j];
}

#pragma package(smart_init)
